<?php

function restartServer()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   return ServerRestart($sock);
}
function rebootServer()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   return ServerReboot($sock);
}
function logOut()
{
   header("HTTP/1.0 401 Unauthorized");
   $sock = Login();
   return true;
   die();
}
function tryAuth()
{
   if (empty($_SERVER["PHP_AUTH_DIGEST"])) {
      print_unauth_header();
      die("Authentication required");
   }
   $sock = Login();
   socket_close($sock);
}
function loadUserConfig()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $str = "CONFIG read user";
   saveConfig($sock, $str);
}
function saveUserConfig()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $str = "CONFIG save user";
   saveConfig($sock, $str);
}
function saveSystemConfig()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $str = "CONFIG save current";
   saveConfig($sock, $str);
}
// function upload()
// {
//     $sock = Login();
//     checkActionAccess($sock, 'write');
//     $content_type = isset($_SERVER['CONTENT_TYPE']) ? $_SERVER['CONTENT_TYPE'] : '';

//     if (stripos($content_type, 'multipart/form-data') === false) {
//         throw new Exception('Content-Type must be multipart/form-data');
//     }

//     $zipfile = $_FILES['uploadfile']['tmp_name'];
//     $zip = zip_open($zipfile);

//     if (!is_resource($zip)) {
//         echo "Zip error" . $zip;
//     }

//     $json = array();
//     [$OKtoUpdate, $json] = generateStatusOk($zip, $sock, $json);

//     if ($OKtoUpdate) {
//         [$vi_update_success, $web_update_success, $json] = readyToUpdate($sock, $zipfile, $json);
//     }

//     if ($vi_update_success) {
//         echo json_encode($json);
//         ServerReboot($sock);
//     } else if ($web_update_success) {
//         ServerRestart($sock);
//     }

//     socket_close($sock);
// }

function upload()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";

   if (stripos($content_type, "multipart/form-data") === false) {
      throw new Exception("Content-Type must be multipart/form-data");
   }

   $json = [];

   $arr = ParamGet($sock, "server");
   $server_v_str = $arr->server->video->version;
   $server_v_arr = explode(".", $server_v_str);

   $server_version = VersionConvert2IntArray($server_v_arr, true);

   $OKtoUpdate = false;
   $info_found = false;

   $zipfile = $_FILES["uploadfile"]["tmp_name"];
   $zip = zip_open($zipfile);

   if (is_resource($zip)) {
      do {
         $entry = zip_read($zip);
         if (is_resource($entry)) {
            $rangestr = "";
            $range_array = [];

            if (zip_entry_name($entry) == "update/info") {
               $info_found = true;

               zip_entry_open($zip, $entry, "r");
               $entry_content = zip_entry_read($entry, zip_entry_filesize($entry));

               $rangestr = strtok($entry_content, "\r\n");

               if ($rangestr != "") {
                  $rangeitem = strtok($rangestr, ",");
                  while ($rangeitem !== false) {
                     array_push($json, ["range" => $rangeitem]);
                     $range_item = explode("-", $rangeitem);
                     $ver1 = explode(".", $range_item[0]);
                     $ver2 = explode(".", $range_item[1]);
                     array_push($range_array, [
                        VersionConvert2IntArray($ver1, true),
                        VersionConvert2IntArray($ver2, false),
                     ]);
                     $rangeitem = strtok(",");
                  }
                  foreach ($range_array as $range_item) {
                     if (VerInRange($server_version, $range_item)) {
                        $OKtoUpdate = true;
                        break;
                     }
                  }
               }
               if ($OKtoUpdate == true) {
                  array_push($json, ["isOk" => true]);
               } else {
                  array_push($json, ["isOk" => false]);
                  socket_close($sock);
                  return $json;
                  die();
               }
               zip_entry_close($entry);
            }
         }
      } while ($entry && !$info_found);
   } else {
      socket_close($sock);
      return "Zip error" . $zip;
   }
   zip_close($zip);

   if ($OKtoUpdate) {
      $zip = zip_open($zipfile);
      if (is_resource($zip)) {
         do {
            $entry = zip_read($zip);
            if (is_resource($entry)) {
               if (zip_entry_name($entry) == "update/vi") {
                  $vifile = "/tmp/tmpfs/vi" . basename($_FILES["uploadfile"]["tmp_name"]);
                  zip_entry_open($zip, $entry);
                  if ($fd = fopen($vifile, "w+")) {
                     $wbytes = fwrite($fd, zip_entry_read($entry, zip_entry_filesize($entry)));
                     fclose($fd);
                     if ($wbytes) {
                        $vi_update_success = ServerUpdate($sock, $vifile);
                        $json[1]["viCopyTime"] = $vi_update_success;
                     }
                     unlink($vifile);
                  }
                  zip_entry_close($entry);
               } elseif (zip_entry_name($entry) == "update/domi.web") {
                  $webfile = "/tmp/tmpfs/domi.web" . basename($_FILES["uploadfile"]["tmp_name"]);
                  zip_entry_open($zip, $entry);
                  if ($fd = fopen($webfile, "w+")) {
                     $wbytes = fwrite($fd, zip_entry_read($entry, zip_entry_filesize($entry)));
                     fclose($fd);
                     if ($wbytes) {
                        $web_update_success = ServerUpdateWeb($sock, $webfile);
                        $json[1]["webCopyTime"] = $web_update_success;
                     }
                     unlink($webfile);
                  }
                  zip_entry_close($entry);
               }
            }
         } while ($entry);
      }
      zip_close($zip);
   }

   if ($vi_update_success) {
      if (ServerReboot($sock)) {
         socket_close($sock);
         return $json;
      }
   } elseif ($web_update_success) {
      if (ServerRestart($sock)) {
         socket_close($sock);
         return $json;
      }
   }
   socket_close($sock);
}

function generateStatusOk($zip, $sock, $json)
{
   $arr = ParamGet($sock, "server");
   $server_v_arr = explode(".", $arr->server->video->version);
   $server_version = VersionConvert2IntArray($server_v_arr, true);

   $OKtoUpdate = false;
   $info_found = false;
   do {
      $entry = zip_read($zip);
      if (!is_resource($entry) || zip_entry_name($entry) != "update/info") {
         zip_entry_close($entry);
         break;
      }

      $rangestr = "";
      $range_array = [];
      $info_found = true;

      zip_entry_open($zip, $entry, "r");

      $rangestr = getRangestr($entry);
      if ($rangestr != "") {
         $rangeitem = strtok($rangestr, ",");
         while ($rangeitem !== false) {
            array_push($json, ["range" => $rangeitem]);
            $range_item = explode("-", $rangeitem);
            $ver1 = explode(".", $range_item[0]);
            $ver2 = explode(".", $range_item[1]);
            array_push($range_array, [
               VersionConvert2IntArray($ver1, true),
               VersionConvert2IntArray($ver2, false),
            ]);
            $rangeitem = strtok(",");
         }
         foreach ($range_array as $range_item) {
            if (VerInRange($server_version, $range_item)) {
               $OKtoUpdate = true;
               break;
            }
         }
      }

      array_push($json, ["isOk" => $OKtoUpdate]);
      if (!$OKtoUpdate) {
         echo json_encode($json);
         die();
      }
      zip_entry_close($entry);
   } while ($entry && !$info_found);

   zip_close($zip);
   return [$OKtoUpdate, $json];
}

function readyToUpdate($sock, $zipfile, $json)
{
   $zip = zip_open($zipfile);
   $vi_update_success = false;
   $web_update_success = false;

   if (!is_resource($zip)) {
      zip_close($zip);
      return [$vi_update_success, $web_update_success, $json];
   }
   do {
      $entry = zip_read($zip);

      if (
         !is_resource($entry) ||
         (zip_entry_name($entry) !== "update/vi" && zip_entry_name($entry) !== "update/domi.web")
      ) {
         break;
      }

      zip_entry_open($zip, $entry);
      $type = zip_entry_name($entry) == "update/vi" ? "vi" : "domi.web";
      $name = "/tmp/tmpfs/" . $type . basename($_FILES["uploadfile"]["tmp_name"]);
      $fd = fopen($name, "w+");

      if ($fd) {
         $wbytes = fwrite($fd, zip_entry_read($entry, zip_entry_filesize($entry)));
         fclose($fd);
         if ($wbytes) {
            if (zip_entry_name($entry) == "update/vi") {
               $vi_update_success = ServerUpdate($sock, $name);
               $json[1]["viCopyTime"] = $vi_update_success;
            } else {
               $web_update_success = ServerUpdateWeb($sock, $name);
               $json[1]["webCopyTime"] = $web_update_success;
            }
         }
         unlink($name);
      }
      zip_entry_close($entry);
   } while ($entry);

   zip_close($zip);
   return [$vi_update_success, $web_update_success, $json];
}

function getRangestr($entry)
{
   $entry_content = zip_entry_read($entry, zip_entry_filesize($entry));
   $rangestr = strtok($entry_content, "\r\n");

   return $rangestr;
}
